import time, sys

def clamp(val, min, max):
        if val < min: return min
        if val > max: return max
        return val

def skal (x, x1, x2, y1, y2):
       if x > x2: return y2
       if x < x1: return y1
       m = (y2 - y1) / (x2 - x1)
       y = m * x + y1
       return y
        
def FanParameter():
     global FanOK
     global maxRPM
     global FanType
     TYPE_PWM = 0
     TYPE_VOLTAGE = 1

     # speichere die maximal einstellbare Luefterdrehzahl 
     open("/proc/stb/fp/fan_vlt", "w").write("ff")
     open("/proc/stb/fp/fan_pwm", "w").write("ff")
     time.sleep (5)
     maxRPM = int(open("/proc/stb/fp/fan_speed").read().split(' ')[0])

     # Test ob Luefter eingebaut - Drehzahl darf nicht mehr 0 sein
     # sonst Tacho defekt oder kein Luefter eingebaut 
     if maxRPM == 0:
          FanOK = False
          open("/proc/stb/fp/fan_vlt", "w").write("00")
          open("/proc/stb/fp/fan_pwm", "w").write("00")
          return
     else:
         FanOK = True

     # was fuer einen Luefter haben wir denn eingebaut
     # reagiert er auf fan_pwm dann pwm-Luefter (4pol), sonst Spannung (3pol)
     open("/proc/stb/fp/fan_pwm", "w").write("00")
     time.sleep (5)
     minPWM = int(open("/proc/stb/fp/fan_speed").read().split(' ')[0])
     if minPWM < maxRPM * 0.8:
          FanType = TYPE_PWM
     else:
          FanType = TYPE_VOLTAGE
     return

class TemperatureSensor(object):
        pass

class FPTemperature(TemperatureSensor):
        def __init__(self, index):
                self.index = index

        def readTemp(self):
                t = int(open("/proc/stb/fp/temp%d"%self.index).read()) / 256.0 * 3.3
                t = 4.246e1 * t + 7.362e-1
                return t

        current = property(readTemp)

class FanControl(object):
        pass

class FPFanControl(FanControl):
        TYPE_PWM = 0
        TYPE_VOLTAGE = 1
         
        def __init__(self, type):
                self.zeroRPM = False
                self.type = type
                # in case of a PWM fan, set voltage to max
                if type == self.TYPE_PWM:
                        open("/proc/stb/fp/fan_vlt", "w").write("ff")
                else:
                        # and vice-versa, but that doesn't really matter.
                        open("/proc/stb/fp/fan_pwm", "w").write("ff")

        def setOutput(self, output):
                if self.zeroRPM:
                     output = 0
#                     open("/proc/stb/fp/led_set", "w").write("00")
#                else:
#                     open("/proc/stb/fp/led_set", "w").write("05")                
                print "set fan output to %d" % output,
                if self.type == self.TYPE_PWM:
                     if self.zeroRPM:
                        open("/proc/stb/fp/fan_vlt", "w").write("00")
                     else:
                        open("/proc/stb/fp/fan_vlt", "w").write("ff")     

                     open("/proc/stb/fp/fan_pwm", "w").write("%x" % output)
                     print "pwm"
                else:
                     open("/proc/stb/fp/fan_vlt", "w").write("%x" % output)
                     print "vlt"

        output = property(None, setOutput)
        
        def getRPM(self):
                return int(open("/proc/stb/fp/fan_speed").read().split(' ')[0])

        rpm = property(getRPM)

class FanLoop(object):
        pass

class PID:
        def __init__(self, Kp = 1/100.0, Ki=1/100.0, Kd=0):
                self.Kp = Kp
                self.Ki = Ki
                self.Kd = Kd
                self.i = 0
                self.prev = 0

        def cycle(self, current, target, dT = 1.0):
                error = target - current
                self.i += error * dT
                
                deriv = (error - self.prev) / dT
                out = self.Kp * error + self.Ki * self.i + self.Kd * deriv
                self.prev = error
                return out

class FanLoopPID(FanLoop):

        def __init__(self, fan):
                self.fan = fan
                self.target_rpm = 1000
                self.pid = PID()

        def cycle(self, dT=1.0):
                cur_rpm = self.fan.rpm
                if self.target_rpm == 0:
                     zeroRPM = True
                else:
                     zeroRPM = False
                out = self.pid.cycle(cur_rpm, self.target_rpm)
                print "current rpm: %d, target_rpm: %d" % (cur_rpm, self.target_rpm),
                self.fan.zeroRPM = zeroRPM
                self.fan.output = clamp(out, 0, 255)

class TemperatureLoop:
        def __init__(self, sensors):
                self.FAN_MIN = 2000
                self.FAN_MAX = 5500
                self.target_temp = 50
                self.Range = 5
                self.FanOFF = False
                self.FanOFFTemp = -1.5
                self.Hystereese = 1.4
                self.sensors = sensors

        def readCurrentTemperature(self):
                return max([s.current  for s in self.sensors])

        def cycle(self, dT=1.0):
                cur_temp = self.readCurrentTemperature()
                e = cur_temp - self.target_temp
                print [int(cur_temp)], e,
                # Luefter AUS (rpm = 0) wenn curr_temp FanOFFtemp unter target_temp
                if e <= self.FanOFFTemp:
                     self.FanOFF = True
                # mit Hystereese erneut einschalten
                if self.FanOFF == True and e >= self.FanOFFTemp + self.Hystereese:
                     self.FanOFF = False 
                if self.FanOFF == True:
                     rpm = 0
                else:
                     # Luefterdrehzahl als lineare Gleichung y = mx + b
                     # wobei git:
                     # x = cur_temp - target_temp
                     # m = (FAN_MAX - FAN_MIN) / Range 
                     # b = FAN_MIN
                     rpm = skal(e, 0, self.Range, self.FAN_MIN, self.FAN_MAX)
                return rpm

FanParameter()

if FanOK == True:
     fl = FanLoopPID(FPFanControl(FanType))
     tl = TemperatureLoop([FPTemperature(x) for x in range(8)])
     tl.target_temp = int(sys.argv[1])
     tl.FAN_MIN = int (sys.argv[2])
     tl.FAN_MAX = maxRPM
     dT = 1
     print
     print "#################################################################"
     print "# Fan Control  -  modified by KLPsAUGER  (NewNigma2.to - Board) #"
     print "#                          v 0.2                                #"
     print "# ###############################################################"
     print "#"
     print "# Lueftermodell:",
     if FanType == 0:
          print " PWM (4-pol.)"
     else:
          print " Voltage (3-pol.)"
     print "# ---------------------------------------------------------------"
     print "# Basisdrehzahl: ", tl.FAN_MIN, "rpm  ", "max.   Drehzahl: ", tl.FAN_MAX, "rpm"
     print "# ---------------------------------------------------------------"
     print "# Solltemperatur:  ", tl.target_temp, "Grad C  Maximaldrehzahl bei: ", tl.target_temp + tl.Range, "Grad C"
     print "# Luefter AUS bei:", tl.target_temp + tl.FanOFFTemp, "Grad C  Hystereese: ",tl.Hystereese, "Grad C" 
     print "#"   
     print "#################################################################"
     print
          
     while True:
             fl.cycle(dT)                                                         
             fl.target_rpm =  tl.cycle(dT)
             time.sleep(dT)
             
else:
     print
     print "no fan detected - leaving fan_ctrl"
